<?php

namespace Drupal\test_custom_entity\Entity\Bundle;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\entity\BundleFieldDefinition;
use Drupal\test_custom_entity\TestCustomEntityInterface;

class Bundle1 extends TestCustomEntityBundle implements TestCustomEntityInterface {

  /**
   * {@inheritdoc}
   */
  public static function bundleFieldDefinitions(EntityTypeInterface $entity_type, $bundle, array $base_field_definitions) {
    $definitions = [];
    if ($bundle == 'bundle1') {
      $definitions['field_1'] = BundleFieldDefinition::create('string')
        ->setName('field_1')
        ->setTargetEntityTypeId($entity_type->id())
        ->setTargetBundle($bundle)
        ->setLabel(t('Field 1)'))
        ->setRequired(FALSE)
        ->setSetting('max_length', 255)
        ->setDisplayOptions('form', [
          'type' => 'string_textfield',
          'weight' => -5,
        ])
        ->setDisplayConfigurable('form', TRUE)
        ->setDisplayOptions('view', [
          'label' => 'inline',
          'type' => 'string',
          'weight' => -5,
        ])
        ->setDisplayConfigurable('view', TRUE);

      $definitions['field_2'] = BundleFieldDefinition::create('string')
        ->setName('field_2')
        ->setTargetEntityTypeId($entity_type->id())
        ->setTargetBundle($bundle)
        ->setLabel(t('Field 2'))
        ->setRequired(FALSE)
        ->setSetting('max_length', 255)
        ->setDisplayOptions('form', [
          'type' => 'string_textfield',
          'weight' => -5,
        ])
        ->setDisplayConfigurable('form', TRUE)
        ->setDisplayOptions('view', [
          'label' => 'inline',
          'type' => 'string',
          'weight' => -5,
        ])
        ->setDisplayConfigurable('view', TRUE);
    }

    return $definitions;
  }

}
