<?php

namespace Drupal\test_custom_entity\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Test custom entity type configuration entity.
 *
 * @ConfigEntityType(
 *   id = "test_custom_entity_type",
 *   label = @Translation("Test custom entity type"),
 *   label_collection = @Translation("Test custom entity types"),
 *   label_singular = @Translation("test custom entity type"),
 *   label_plural = @Translation("test custom entities types"),
 *   label_count = @PluralTranslation(
 *     singular = "@count test custom entities type",
 *     plural = "@count test custom entities types",
 *   ),
 *   handlers = {
 *     "form" = {
 *       "add" = "Drupal\test_custom_entity\Form\TestCustomEntityTypeForm",
 *       "edit" = "Drupal\test_custom_entity\Form\TestCustomEntityTypeForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *     "list_builder" = "Drupal\test_custom_entity\TestCustomEntityTypeListBuilder",
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     }
 *   },
 *   admin_permission = "administer test custom entity types",
 *   bundle_of = "test_custom_entity",
 *   config_prefix = "test_custom_entity_type",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "add-form" = "/admin/structure/test_custom_entity_types/add",
 *     "edit-form" = "/admin/structure/test_custom_entity_types/manage/{test_custom_entity_type}",
 *     "delete-form" = "/admin/structure/test_custom_entity_types/manage/{test_custom_entity_type}/delete",
 *     "collection" = "/admin/structure/test_custom_entity_types"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "uuid",
 *   }
 * )
 */
class TestCustomEntityType extends ConfigEntityBundleBase {

  /**
   * The machine name of this test custom entity type.
   *
   * @var string
   */
  protected $id;

  /**
   * The human-readable name of the test custom entity type.
   *
   * @var string
   */
  protected $label;

}
