<?php

namespace Drupal\test_custom_entity\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the test custom entity entity edit forms.
 */
class TestCustomEntityForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);

    $entity = $this->getEntity();

    $message_arguments = ['%label' => $entity->toLink()->toString()];
    $logger_arguments = [
      '%label' => $entity->label(),
      'link' => $entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New test custom entity %label has been created.', $message_arguments));
        $this->logger('test_custom_entity')->notice('Created new test custom entity %label', $logger_arguments);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The test custom entity %label has been updated.', $message_arguments));
        $this->logger('test_custom_entity')->notice('Updated test custom entity %label.', $logger_arguments);
        break;
    }

    $form_state->setRedirect('entity.test_custom_entity.canonical', ['test_custom_entity' => $entity->id()]);

    return $result;
  }

}
