<?php

namespace Drupal\test_custom_entity;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines a class to build a listing of test custom entity type entities.
 *
 * @see \Drupal\test_custom_entity\Entity\TestCustomEntityType
 */
class TestCustomEntityTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['title'] = $this->t('Label');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['title'] = [
      'data' => $entity->label(),
      'class' => ['menu-label'],
    ];

    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();

    $build['table']['#empty'] = $this->t(
      'No test custom entity types available. <a href=":link">Add test custom entity type</a>.',
      [':link' => Url::fromRoute('entity.test_custom_entity_type.add_form')->toString()]
    );

    return $build;
  }

}
